/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.io;

import java.io.*;
import java.net.*;
import java.nio.channels.*;

public class IOUtils {
    private IOUtils() {}

    public static void closeQuietly(InputStream in) {
        try { in.close(); } catch (IOException e) {}
    }

    public static void closeQuietly(OutputStream out) {
        try { out.close(); } catch (IOException e) {}
    }

    public static void closeQuietly(Socket s) {
        try { s.close(); } catch (IOException e) {}
    }

    public static void closeQuietly(ServerSocket s) {
        try { s.close(); } catch (IOException e) {}
    }

    public static void closeQuietly(Reader in) {
        try { in.close(); } catch (IOException e) {}
    }

    public static void closeQuietly(Writer out) {
        try { out.close(); } catch (IOException e) {}
    }

    public static void closeQuietly(Channel ch) {
        try { ch.close(); } catch (IOException e) {}
    }

    public static void shutdownOutputQuietly(Socket s) {
        try { s.shutdownOutput(); } catch (IOException e) {}
    }

    public static void shutdownInputQuietly(Socket s) {
        try { s.shutdownOutput(); } catch (IOException e) {}
    }
}
